//Using explicit formula for  1-D discrete Fourier transform
//------------------------------------------------
//Code taken from https://help.scilab.org/docs/5.4.1/ru_RU/fft.html

function xf=dft(x, flag);
  n=size(x,'*');
  //Compute the n by n Fourier matrix
  if flag==1 then,//backward transformation
    am=exp(2*%pi*%i*(0:n-1)'*(0:n-1)/n);
  else //forward transformation
    am=exp(-2*%pi*%i*(0:n-1)'*(0:n-1)/n);
  end
  xf=am*matrix(x,n,1);//dft
  xf=matrix(xf,size(x));//reshape
  if flag==1 then,xf=xf/n;end
endfunction
